*
*
* ARP SUPPORT FOR MARINA - BY D. FINNIGAN
*
* THIS FILE CONTAINS DATA STRUCTURE AND ALL SUPPORT ROUTINES
* FOR THE ADDRESS RESOLUTION PROTOCOL.
*
ARPTRIES DFB 0 ; NUMBER OF TIMES TO TRY A REQUEST
MERGEFLAG DFB 0
*
* ARP TABLE IS 4 BYTE IP THEN 6 BYTE MAC
*
ARPENTRIES EQU 4 ; NUMBER OF ENTRIES IN ARP TABLE
ARPTIMER EQU 45 ; DEFAULT TIME TO LIVE FOR ENTRY
*
ARPTEMP DS 10 ; TEMP HOLDER FOR AN IP-MAC PAIR
ARPTAB DS 10*ARPENTRIES ; DATA TABLE
ARPTABTIM DS ARPENTRIES ; TIMER TABLE
ARPNEXTENT DFB 0 ; NEXT TABLE ENTRY TO USE, IF FULL
*
* MULTICAST EXTENSIONS - RFC 1112
* FOLLOWING IS 10 BYTES USED IN FORMING THE ETHERNET MCAST ADDR
MCASTARPDAT DS 10
*
*
*
* SEND AN RFC 5227 ARP PROBE TO DETECT IF OUR IP
* ADDRESS IS IN USE BY ANOTHER HOST.
*
ARPPROBE
 LDA #42 ; ARP PACKETS ARE 42 BYTES LONG
 STA OUTPLEN
 LDA #0
 STA OUTPLEN+1
 LDA #<ARPPRBDAT ; LOW BYTE OF DATA PACKET LOCATION
 STA OUTPBUF
 LDA #>ARPPRBDAT ; HIGH BYTE
 STA OUTPBUF+1
* PUT OUR CANDIDATE ADDRESS IN THE PROBE PACKET
 LDY #41 ; OFFSET
 LDX #3
:L LDA IPADDR,X
 STA (OUTPBUF),Y
 DEY
 DEX
 BPL :L
 JSR ETHSEND ; OFF IT GOES
 RTS
*
* THE ACTUAL DATA OF THE ARP PROBE
ARPPRBDAT
 HEX FFFFFFFFFFFF
 HEX 0080106D7630
 HEX 080600010800
 HEX 060400010080
 HEX 106D76300000
 HEX 000000000000
 HEX 000000000000
*
*
* SEND AN RFC 5227 ARP ANNOUNCEMENT
* THIS IS PRETTY SHORT AND SWEET. THE MAC ADDRESS IS HARDCODED.
* RETURNS WITH CARRY FLAG CLEAR TO MEAN NO ERROR
*
ARPANNOUNCE
 LDA #42 ; ARP PACKETS ARE 42 BYTES LONG
 STA OUTPLEN
 LDA #0
 STA OUTPLEN+1
 LDA #<ARPANNDAT ; LOW BYTE OF DATA PACKET LOCATION
 STA OUTPBUF
 LDA #>ARPANNDAT ; HIGH BYTE
 STA OUTPBUF+1
* PUT OUR IP ADDRESS IN THE ANNOUNCEMENT PACKET (2 PLACES)
 LDY #31 ; OFFSET
 LDX #3
:L LDA IPADDR,X
 STA (OUTPBUF),Y
 DEY
 DEX
 BPL :L
 LDY #41 ; OFFSET
 LDX #3
:L2 LDA IPADDR,X
 STA (OUTPBUF),Y
 DEY
 DEX
 BPL :L2
 JSR ETHSEND ; OFF IT GOES
 BCS :DONE2 ; SEND ERROR?
* WE SENT IT. NOW GO TELL A FRIEND.
 DO DEBUG
 LDY #0
:L3 LDA MSG3,Y
 BEQ :DONE
 JSR COUT
 INY
 BNE :L3
 FIN
:DONE CLC
:DONE2 RTS
* FOLLOWING IS THE ACTUAL ARP PACKET DATA
ARPANNDAT
 HEX FFFFFFFFFFFF
 HEX 0080106D7630
 HEX 080600010800
 HEX 060400010080
 HEX 106D7630A9FE
 HEX 020300000000
 HEX 0000A9FE0203
*
*
* LOOKUP AN ARP ENTRY BY IP NUMBER
* POINTER TO FIRST BYTE OF IP NUMBER STORED IN PTR.
* IF THE ENTRY IS FOUND, ITS OFFSET IS RETURNED IN THE X-REG
* AND THE CARRY FLAG IS CLEAR.
* IF NOT FOUND, X=$FF AND CARRY FLAG IS SET.
*
ARPLOOKUP
 LDX #0 ; TABLE ENTRY NUMBER
 TXA
 PHA  ; SAVE OUR ENTRY FOR LATER
:L LDY #0 ; LOOKUP IP POINTER
:L2 LDA (PTR),Y ; GET FIRST BYTE OF IP
 CMP ARPTAB,X ; AND COMPARE WITH A TABLE ENTRY
 BNE :NEXT
 INX
 INY
 CPY #4
 BEQ :FOUND ; FOUND THE MATCH!
 BNE :L2
:NEXT   ; NO, TRY NEXT TABLE ENTRY
 PLA
 TAX  ; RESTORE ENTRY NUMBER
 INX
 CPX #ARPENTRIES ; REACHED END OF TABLE?
 BEQ :NOTFOUND ; YES, SO EXIT
 TXA
 PHA
* NOW SET X TO THE NEXT ARP TABLE ENTRY
 CLC
 LDA #0
:L3 ADC #10
 DEX
 BNE :L3
 TAX ; OUR NEW TABLE OFFSET
 BNE :L ; SEARCH NEXT TABLE ENTRY
* MATCHING ENTRY WAS FOUND, SO RETURN ITS POINTER
:FOUND
 PLA
 TAX  ; TABLE ENTRY NUMBER
 LDA ARPTABTIM,X ; CHECK TIME TO LIVE
 BEQ :NOTFOUND ; TIMER EXPIRED
 CLC
 LDA #0
:L4 DEX
 BMI :FOUND2 ; RETURN WITH OFFSET
 ADC #10
 BNE :L4
:FOUND2 TAX
 CLC
 RTS
* NO ENTRY FOUND SO RETURN X=FF AND SET CARRY
:NOTFOUND
 LDX #$FF
 SEC
 RTS
*
*
* ADD AN ENTRY TO THE ARP TABLE
* PTR MUST POINT TO THE START OF 10 BYTES, THE FIRST 4 NEED
* TO BE THE IP ADDRESS TO BE ADDED, THE LAST 6 THE MAC.
* IF TABLE IS FULL, ENTRIES ARE REPLACED IN ROUND-ROBIN.
*
ARPADD
 LDX #0 ; WHICH TABLE ENTRY WILL WE USE?
 LDY #0 ; LOOP COUNTER
 LDA (PTR),Y ; VALID IP ADDR?
 BEQ :BADIP ; NO, SO EXIT
:L LDA ARPTAB,X
 BEQ :FOUNDSLOT ; WE CAN USE THIS ENTRY
 INY
 CPY #ARPENTRIES ; ARE WE AT THE END OF THE TABLE?
 BEQ :NOSLOTS
 TXA
 CLC
 ADC #10 ; POINT TO NEXT TABLE ENTRY
 TAX
 BNE :L ; ALWAYS TAKEN
* IF TABLE IS FULL, GET NEXT ENTRY TO REPLACE
:NOSLOTS
 LDX ARPNEXTENT
 INX
 CPX #ARPENTRIES
 BNE :NOSLOTS2
 LDX #0 ; WRAP AROUND TO ENTRY 0
* NOW WE SHOULD HAVE AN ENTRY TO OVERWRITE.
* COMPUTE ITS OFFSET IN ARPTAB
:NOSLOTS2
 STX ARPNEXTENT ; SAVE THIS FOR NEXT TIME.
 TXA  ; WE NEED THIS OFFSET IN Y,
 TAY ; IT'S USED FOR :FOUNDSLOT BELOW.
 BEQ :FOUNDSLOT ; ARPTAB OFFSET IS 0
 LDA #0 ; WILL HOLD ARPTAB OFFSET
 CLC
:OFL ADC #10 ; ENTRY SIZE
 DEX
 BNE :OFL
 TAX  ; ARPTAB OFFSET NOW IN X
*
* WE FOUND A SLOT. THE X-REG NOW POINTS TO THE FIRST BYTE
* WHERE WE CAN STORE THE IP ADDRESS. THEN THE MAC ADDRESS COMES
* RIGHT AFTER.
:FOUNDSLOT
 LDA #ARPTIMER ; DEFAULT ENTRY TIME
 STA ARPTABTIM,Y
 LDY #0
:L2 LDA (PTR),Y
 STA ARPTAB,X
 INX
 INY
 CPY #10 ; 10 BYTES TO COPY
 BNE :L2
 CLC  ; SIGNAL NO ERROR
 RTS
*
:BADIP
 SEC
 RTS
*
*
* ARPREQUEST
* WHEN ARPLOOKUP DID NOT RETURN A MATCH, CALL THIS SUBROUTINE.
* SUPPORT ADDED FOR MULTICAST ADDRESSES - 21 JUN 15
* PTR POINTS TO FIRST BYTE OF IP ADDRESS TO REQUEST
*
ARPREQUEST
* COPY TARGET IP ADDRESS FROM PTR
 LDY #0 ; OFFSET FOR PTR
 LDA (PTR),Y
 AND #%11110000 ; GET HIGH NYBBLE
 CMP #MCASTCLASS ; MULTICAST CLASS?
 BEQ :MCAST ; YES, SO FORM THE MAC ADDR
*
 LDX #38 ; OFFSET FOR ARPREQDAT
:L1 LDA (PTR),Y
 STA ARPREQDAT,X
 INX
 INY
 CPY #4
 BNE :L1
* GET READY
 LDA #42 ; ARP REQUEST LENGTH
 STA OUTPLEN
 LDA #0
 STA OUTPLEN+1
 LDA #<ARPREQDAT
 STA OUTPBUF
 LDA #>ARPREQDAT
 STA OUTPBUF+1
 JSR ETHSEND
 BCS :DONE ; SEND ERROR?
* TELL ABOUT ALL IT!
 DO DEBUG
 LDY #0
:L2 LDA MSG12,Y
 BEQ :DONE
 JSR COUT
 INY
 BNE :L2
 FIN
:DONE RTS
* FORM MULTICAST ETHERNET ADDRESS
:MCAST
 LDX #0
:MCL LDA (PTR),Y
 STA MCASTARPDAT,X
 INY
 INX
 CPX #4
 BNE :MCL
*
 LDA #1
 STA MCASTARPDAT+4
 LDA #0
 STA MCASTARPDAT+5
 LDA #94
 STA MCASTARPDAT+6
 LDY #1
 LDX #7
:MCL2 LDA (PTR),Y
 STA MCASTARPDAT,X
 INX
 INY
 CPY #4
 BNE :MCL2
 LDA #<MCASTARPDAT
 STA PTR
 LDA #>MCASTARPDAT
 STA PTR+1
 JSR ARPADD
 BCS :DONE ; ERROR
 JMP IPSEND2
*
*
ARPREQDAT HEX FFFFFFFFFFFF
 HEX 0080106D7630
 HEX 080600010800
 HEX 060400010080
 HEX 106D76300000
 HEX 000000000000
 HEX 000000000000
*
*
* ARPEXPIRE
* LOOPS OVER ALL ARPTAB ENTRIES AND DECREMENTS THE
* TIME TO LIVE VALUES.
*
ARPEXPIRE
 LDX #ARPENTRIES-1
:L LDA ARPTABTIM,X ; CHECK TIMER
 BEQ :NEXT ; ALREADY EXPIRED, SKIP IT
 DEC ARPTABTIM,X
:NEXT DEX
 BPL :L
 RTS
*
*
* ARPINIT
* COPY OUR IP ADDRESS AND MAC ADDRESS TO ARPREQDAT
* AND CLEAR THE ARP TABLE
*
ARPINIT
* CLEAR ARPTAB
 LDX #10*ARPENTRIES-1
 LDA #0
:L STA ARPTAB,X
 DEX
 BPL :L
 STA ARPTRIES
 STA ARPNEXTENT
* CLEAR ARPTABTIME
 LDX #ARPENTRIES-1
:L2 STA ARPTABTIM,X
 DEX
 BPL :L2
* COPY IP ADDRESS TO ARP REQUEST TEMPLATE
 LDX #3 ; IPADDR OFFSET
 LDY #31 ; ARPREQDAT OFFSET
:L3 LDA IPADDR,X
 STA ARPREQDAT,Y
 DEY
 DEX
 BPL :L3
* COPY MAC ADDRESS TO ARP REQUEST TEMPLATE (TWO PLACES)
 LDX #5 ; OURMAC OFFSET
 LDY #11 ; ARPREQDAT OFFSET
:L4 LDA OURMAC,X
 STA ARPREQDAT,Y
 DEY
 DEX
 BPL :L4
 LDX #5
 LDY #27
:L5 LDA OURMAC,X
 STA ARPREQDAT,Y
 DEY
 DEX
 BPL :L5
* COPY MAC ADDRESS TO ARP ANNOUNCEMENT TEMPLATE
 LDX #5
 LDY #11 ; ARPANNDAT OFFSET
:L6 LDA OURMAC,X
 STA ARPANNDAT,Y
 DEY
 DEX
 BPL :L6
 LDX #5
 LDY #27
:L7 LDA OURMAC,X
 STA ARPANNDAT,Y
 DEY
 DEX
 BPL :L7
* COPY MAC ADDRESS TO ARP PROBE TEMPLATE
* AND OUTPHEAD
 LDX #5
 LDY #11 ; ARPPRBDAT
:L8 LDA OURMAC,X
 STA ARPPRBDAT,Y
 STA OUTPHEAD,Y
 DEY
 DEX
 BPL :L8
 LDX #5
 LDY #27
:L9 LDA OURMAC,X
 STA ARPPRBDAT,Y
 DEY
 DEX
 BPL :L9
 RTS
*
*
* PRINT THE ARP TABLE IN HUMAN-READABLE FORMAT
* THE TABLE STARTS AT ARPTAB AND IS 10*ARPENTRIES LONG
* EACH ENTRY IS 10 BYTE: IP, THEN MAC.
* ALSO PRINTS TIME TO LIVE FROM ARPTABTIM.
*
PRNTARPTAB
* PREPARE PTR FOR IP ADDRESS
 LDA #<ARPTAB
 STA PTR
 LDA #>ARPTAB
 STA PTR+1
 LDX #0 ; ENTRIES COUNTER
:L TXA
 PHA
 JSR PRNTIPDEC
 LDA #" "
 JSR COUT
 LDA #"A"
 JSR COUT
 LDA #"T"
 JSR COUT
 LDA #" "
 JSR COUT
* NOW PRINT THE MAC ADDRESS
 CLC
 LDA PTR
 ADC #4 ; LENGTH OF IP ADDRESS
 STA PTR
 LDA PTR+1
 ADC #0
 STA PTR+1
 LDY #0
:L3 LDA (PTR),Y
 JSR PRBYTE
 LDA #":"
 JSR COUT
 INY
 CPY #5 ; NO COLON AFTER LAST BYTE
 BNE :L3
 LDA (PTR),Y
 JSR PRBYTE
* POINT TO NEXT ENTRY
 LDA PTR
 ADC #6 ; LENGTH OF MAC ADDR
 STA PTR
 LDA PTR+1
 ADC #0
 STA PTR+1
* NOW GET OUR ENTRIES COUNTER BACK AND TEST IT
 PLA
 TAX
* PRINT TIME TO LIVE
 LDA #" "
 JSR COUT
 LDA ARPTABTIM,X
 JSR PRBYTE
 LDA #$8D
 JSR COUT
*
 INX
 CPX #ARPENTRIES
 BNE :L
 RTS
*
*
* THIS IS A CORRECT IMPLEMENTATION OF RFC 826
* FOLLOWING THE ALGORITHM OUTLINED IN "PACKET RECEPTION,"
* WITH ADDITIONAL TESTS FOR LINK-LOCAL ADDRESSING IN RFC 3927.
*
HANDLEARP
 CLC
 LDA INPBUF ; ADVANCE THE POINTER...
 ADC #ETHHLEN ; ...14 BYTES TO THE ARP DATA
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
*
* FIRST CHECK THE HARDWARE TYPE. IT SHOULD BE 0001 FOR ETH
 LDY #0
 LDA (INPBUF),Y
 BEQ :CHECKH2
 JMP :BADARP
:CHECKH2 INY
 LDA (INPBUF),Y
 CMP #1
 BEQ :CHECKPROT ; WE DON'T LIKE THIS HARDWARE TYPE
 JMP :BADARP
*
* SO FAR, SO GOOD. NOW CHECK THAT PROTOCOL TYPE IS 0800
:CHECKPROT
 INY
 LDA (INPBUF),Y
 CMP #8 ; IP
 BEQ :CHECKP2 ; WE DON'T SPEAK YOUR LANGUAGE!
 JMP :BADARP
:CHECKP2 INY
 LDA (INPBUF),Y
 BEQ :CHECKHL
 JMP :BADARP
:CHECKHL INY
 LDA (INPBUF),Y ; CHECK HARDWARE LENGTH
 CMP #6 ; ETHERNET
 BEQ :PROP
 JMP :BADARP
*
* PRINT OPCODE
:PROP
 DO DEBUG
 LDA #" "
 JSR COUT
 LDA #"R"
 JSR COUT
 LDA #"E"
 JSR COUT
 LDY #7
 LDA (INPBUF),Y
 CMP #1
 BEQ :PRREQ ; REQUEST
 LDA #"P"
 BNE :PROP2
:PRREQ LDA #"Q"
:PROP2 JSR COUT
 FIN
* CHECK IF SENDER IP (PROTOCOL) ADDRESS IS IN THE TABLE
:CHECKSEND
 LDA #0 ; SET MERGEFLAG TO FALSE
 STA MERGEFLAG
* SKIP OVER ALL ZERO SENDER PROTOCOL ADDRESS (ARP PROBE)
 LDY #14 ; POINT TO SENDER PROTOCOL ADDRESS
:CHKZL LDA (INPBUF),Y
 BEQ :CHECKTARGET ; ZERO ADDRESS, SO MOVE ON
 INY
 CPY #18
 BNE :CHKZL
* NOT AN ARP PROBE, SO PROCEED WITH LOOKUP
 CLC
 LDA INPBUF ; COPY THE POINTER TO PTR
 ADC #14 ; POINT TO SENDER PROTOCOL ADDRESS
 STA PTR
 LDA INPBUF+1
 ADC #0
 STA PTR+1
 JSR ARPLOOKUP
 BCS :ACD ; ENTRY NOT FOUND, SO MOVE ON
* ENTRY WAS FOUND, SO UPDATE THE SENDER HARDWARE ADDRESS
* AND SET MERGEFLAG.
 LDY #8 ; POINT TO HARDWARE ADDRESS
 INX
 INX
 INX
 INX
:L LDA (INPBUF),Y
 STA ARPTAB,X
 INX
 INY
 CPY #14
 BNE :L
 LDA #$80 ; SET MERGEFLAG TO TRUE
 STA MERGEFLAG
* ADRESS CONFLICT DETECTION - RFC 3927
* IF DURING THE PROBE PERIOD WE FIND A SENDER IP = OUR IP, THEN
* WE HAVE TO PICK A NEW ADDRESS.
:ACD
 LDY #17 ; POINT TO SENDER IP ADDR
 LDX #3
:ACDL LDA (INPBUF),Y
 CMP IPADDR,X
 BNE :CHECKTARGET
 DEY
 DEX
 BPL :ACDL
* IF OUTSIDE OF PROBE PERIOD, CHECK SENDER MAC == OUR MAC
 LDA PROBENUM
 BNE :IPRECONF ; WITHIN PROBE PERIOD
 LDX #5
 LDY #13 ; POINT TO SENDER MAC
:ACDL2 LDA (INPBUF),Y
 CMP OURMAC,X
 BNE :IPRECONF ; NOT OUR MAC, SO RECONFIGURE
 DEY
 DEX
 BPL :ACDL
 BMI :CHECKTARGET ; IT WAS OUR MAC ADDRESS
* IP MATCHED SO WE NEED TO RECONFIGURE
:IPRECONF
 LDA #0 ; FORCE NEW ADDRESS SELECTION
 STA IPADDR
 DO DEBUG
 TAY
:ACDL3 LDA MSG15,Y
 BEQ :ACDNEXT
 JSR COUT
 INY
 BNE :ACDL3
 FIN
:ACDNEXT JMP IPRECONFIG ; AVOID NESTED SUBROUTINES
* CHECK IF THE TARGET PROTOCOL ADDRESS MATCHES OURS
:CHECKTARGET
 LDY #27 ; POINT TO TARGET PROTOCOL ADDRESS
 LDX #3
:L2 LDA (INPBUF),Y
 CMP IPADDR,X
 BEQ :CHECKT2
 JMP :NOMATCH
:CHECKT2 DEY
 DEX
 BPL :L2
* IF WE MADE IT HERE THEN WE HAVE A MATCH.
* ADDRESS CONFLICT DETECTION - RFC 3927
* CHECK ARP PROBE WHERE TARGET IP ADDR = OUR IP
 LDA PROBENUM
 BEQ :ARPADD ; NOT PROBING, SO MOVE ON
 LDY #14 ; POINT TO SENDER IP ADDR
:ACDL4 LDA (INPBUF),Y
 BNE :ARPADD ; NO CONFLICT
 INY
 CPY #18
 BNE :ACDL4
* ADDRESS CONFLICT, RECONFIGURE
 LDA #0
 STA IPADDR
 JMP IPRECONFIG
* COPY SENDER IP-MAC PAIR INTO ARPTEMP THEN CALL ARPADD
* IF MERGEFLAG IS FALSE.
:ARPADD LDX #3 ; ARPTEMP POINTER
 LDY #17 ; POINT TO SENDER PROTO ADDRESS
:L3 LDA (INPBUF),Y
 STA ARPTEMP,X
 DEY
 DEX
 BPL :L3
 LDX #4
 LDY #8 ; POINT TO SENDER HARDW ADDRESS
:L4 LDA (INPBUF),Y
 STA ARPTEMP,X
 INX
 INY
 CPY #14
 BNE :L4
* CHECK THE MERGE FLAG TO SEE IF WE SHOULD ADD THE SENDER
 LDA MERGEFLAG
 BNE :CHECKOPCODE ; TRUE, SO MOVE ON
 LDA #<ARPTEMP
 STA PTR
 LDA #>ARPTEMP
 STA PTR+1
 JSR ARPADD ; IF THIS FAILS, THERE'S NOTHING WE CAN DO
* NOW CHECK THE ARP OPCODE
:CHECKOPCODE
 LDY #7 ; CHECK OPCODE
 LDA (INPBUF),Y
 CMP #1
 BEQ :SWAP ; NOT A REQUEST
 JMP :NOMATCH
* SWAP HARDWARE AND PROTOCOL FIELDS
* SENDER IP-MAC IS IN ARPTEMP. WE ALSO NEED TO UPDATE THE
* ETHERNET HEADER
:SWAP SEC
 LDA INPBUF
 SBC #ETHHLEN ; BACK UP POINTER TO...
 STA INPBUF ; ...THE ETHERNET HEADER
 LDA INPBUF+1
 SBC #0
 STA INPBUF+1
* NOW COPY SENDER MAC TO TARGET MAC
 LDX #4 ; POINT TO SENDER MAC IN ARPTEMP
 LDY #32 ; POINT TO TARGET MAC IN INPBUF
:L5 LDA ARPTEMP,X
 STA (INPBUF),Y
 INX
 INY
 CPY #38 ; DONE?
 BNE :L5
* COPY SENDER MAC TO ETHERNET DESTINATION
 LDX #9
 LDY #5
:L6 LDA ARPTEMP,X
 STA (INPBUF),Y
 DEX
 DEY
 BPL :L6
* COPY SENDER IP TO TARGET IP
 LDX #3 ; POINT TO IP IN ARPTEMP
 LDY #41 ; POINT TO TARGET IP IN INPBUF
:L7 LDA ARPTEMP,X
 STA (INPBUF),Y
 DEY
 DEX
 BPL :L7 ; DONE?
* SET SENDER MAC TO OUR MAC ADDRESS
 LDY #27 ; POINT TO SENDER MAC IN INPBUF
 LDX #5
:ML LDA OURMAC,X
 STA (INPBUF),Y
 DEY
 DEX
 BPL :ML
* SET ETHERNET SOURCE TO OUR MAC ADDRESS
 LDY #11 ; POINT TO SOURCE MAC IN INPBUF
 LDX #5
:ML2 LDA OURMAC,X
 STA (INPBUF),Y
 DEY
 DEX
 BPL :ML2
* SET SENDER IP TO OUR IP ADDRESS
 LDX #3
 LDY #31 ; POINT TO SENDER IP IN INPBUF
:L8 LDA IPADDR,X
 STA (INPBUF),Y
 DEY
 DEX
 BPL :L8 ; DONE?
* SET OPCODE TO REPLY
 LDY #20 ; POINT TO OPCODE IN INPBUF
 LDA #0
 STA (INPBUF),Y
 INY
 LDA #2 ; REPLY
 STA (INPBUF),Y
* NOW SEND THIS REPLY
 LDA #42 ; ARP PACKETS ARE 42 BYTES LONG
 STA OUTPLEN
 LDA #0
 STA OUTPLEN+1
 LDA INPBUF
 STA OUTPBUF
 LDA INPBUF+1
 STA OUTPBUF+1
 JSR ETHSEND ; AND OFF IT GOES!
:NOMATCH
 RTS
:BADARP
 DO DEBUG
 LDA #$8D
 JSR COUT
 LDA #"B"
 JSR COUT
 LDA #"A"
 JSR COUT
 LDA #"D"
 JSR COUT
 FIN
 SEC  ; FLAG AN ERROR
 RTS
*
*
*
* DEBUG DEBUG DEBUG
ARPTEST
 LDY #0
:L LDA MSG21,Y
 BEQ :NEXT
 JSR COUT
 INY
 BNE :L
:NEXT
 LDA #">"
 STA $33 ; PROMPT
 JSR $FD6A ; GETLN
 LDA #0
 STA PTR
 STA $0200,X
 LDA #2
 STA PTR+1
 JSR VERIPADDR ; VERIFY IP ADDRESS
 BCS :NEXT ; BAD
 JSR IPTOHEX
 LDA #<IPHEXTMP
 STA PTR
 LDA #>IPHEXTMP
 STA PTR+1
 JSR ARPREQUEST
 RTS
